function Toggle(node)
{
	var subnode = node;
	var imgButton = getChildNode(node);
	var imgFolder = getNextNode(imgButton);
	while ((subnode = subnode.nextSibling) && subnode.nodeName != "ul" && subnode.nodeName != "UL");
	if (subnode) {
		if (subnode.style.display == "none") {
			subnode.style.display = "block";
			imgButton.src = "img/minus.png";
			imgFolder.src = "img/folder_open.png";
		} else {
			subnode.style.display = "none";
			imgButton.src = "img/plus.png"
			imgFolder.src = "img/folder_closed.png";
		}
	}
	onClickNode(node);
}

function getNextNode(node)
{
	while ((node = node.nextSibling) && node.nodeType!=1);
	return node;
}

function getChildNode(node)
{
	node = node.firstChild;
	while (node && node.nodeType != 1) {
		node = node.nextSibling;
	} 
	return node;
}

function getKeyOfNode(node)
{
	var key = null;
	var name;
	for(;;) {
		if (node.nodeName == "li" || node.nodeName == "LI") {
			name = node.getAttribute("name");
			if (name) {
				if (name == "_root") break;
				if (!key)
					key = name;
				else
					key = name + "." + key;
			}				
		}
		if (!(node = node.parentNode)) break;
	}
	return key;
}

var lastnode = null;
var lastdesc = null;

function ShowDesc(node)
{
	if (node == lastnode) {
		tooltip.show(lastdesc);
		return;
	}
	var key = getKeyOfNode(node);
	xmlhttp.open("GET", "prefs.xml?text&range&desc&level=1&path=" + key, false);
	xmlhttp.send(null);
	var xml = xmlhttp.responseXML;
	var nodes = xml.getElementsByTagName("node");
	var node = nodes[nodes.length - 1];
	var desc = node.getElementsByTagName("desc");
	var minval = node.getAttribute("min");
	var maxval = node.getAttribute("max");
	//alert(node.getAttribute("key"));
	lastdesc = "<strong>"+key+"</strong>";
	if (minval || maxval) {
		lastdesc += " (";
		if (minval) lastdesc += minval;
		lastdesc += "~";
		if (maxval) lastdesc += maxval;
		lastdesc += ")";
	}
	lastdesc += "<br/><br/>";
	if (desc.length > 0)
		lastdesc += desc[0].firstChild.nodeValue;
	else
		lastdesc += node.getAttribute("text");
		
	if (lastdesc == " ")
		tooltip.hide();
	else
		tooltip.show(lastdesc);
	lastnode = node;
	return lastdesc;
}

function SetValue(node, val)
{
	var key = getKeyOfNode(node);
	var _xmlhttp = newHttpRequest();
	_xmlhttp.open("GET", "set?" + key + "=" + val, true);
	_xmlhttp.send(null);
}

function GetValue(node)
{
	var key = getKeyOfNode(node);
	xmlhttp.open("GET", "get?path=" + key, false);
	xmlhttp.send(null);
	return xmlhttp.responseText == " " ? "" : xmlhttp.responseText;
}

function RevertPrefValue(node)
{
	var key = getKeyOfNode(node);
	xmlhttp.open("GET", "revert?path=" + key, false);
	xmlhttp.send(null);
	var val = xmlhttp.responseText;
	node.value = val  == " " ? "" : val;
}

function onClickNode(node, desc)
{
	if (desc) alert(desc);
}
